#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../scorpion.h"

#define FOND_Z (1.f)
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Fond5 = {0.f,0.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond6 = {640.f,0,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond7 = {640.,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond8 = {0,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Flare1 = {0.f,0.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Flare2 = {640.f,0,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Flare3 = {640.,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Flare4 = {0,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

void LInit_Casting0()
{
	PrepareTextureFromArray(g_PicVolca99, 256, 256, &g_TextureVolca99);
	PrepareTextureFromArray(g_PicFlare, 256, 256, &g_TextureFlare);
}

void QInit_Casting0()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_ALWAYS);
	grDepthMask(FXFALSE);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	grChromakeyValue(0);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	DownloadTexture(&g_TextureVolca99);
	SelectTexture(g_TextureVolca99);
	DownloadTexture(&g_TextureFlare);
}

void Effect_Casting0()
{
	DWORD dwLight;
	DWORD dwTmp;
	int iTmp;
	float fSize;

	if (g_demostate.TickInEffect<1667)
	{
		dwLight = (DWORD)(g_demostate.TickInEffect/6.5f) <<24;
		grConstantColorValue(dwLight);
		grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA,
			GR_BLEND_ONE, GR_BLEND_ZERO);
		grDrawTriangle(&Fond1, &Fond2, &Fond3);			
		grDrawTriangle(&Fond3, &Fond4, &Fond1);
		return;
	}

	if (g_demostate.TickInEffect<1667+1666)
	{
		grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO,
			GR_BLEND_ONE, GR_BLEND_ZERO);
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
				GR_COMBINE_FACTOR_LOCAL,
				GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		dwTmp = (g_demostate.TickInEffect-1667)/6.5f;
		if (dwTmp>256)
			dwTmp = 0;
		else
			dwTmp = 256 - dwTmp;

		grConstantColorValue(dwTmp|(dwTmp<<8)|(dwTmp<<16));
		SelectTexture(g_TextureFlare);

		fSize = 800.f*(float)sin((g_demostate.TickInEffect-1667)/1666.f*PI/2.f);

		Flare1.x = 480.f - fSize;
		Flare2.x = 480.f + fSize;
		Flare3.x = 480.f + fSize;
		Flare4.x = 480.f - fSize;

		Flare1.y = 160.f - fSize;
		Flare2.y = 160.f - fSize;
		Flare3.y = 160.f + fSize;
		Flare4.y = 160.f + fSize;

		guDrawTriangleWithClip(&Flare1, &Flare2, &Flare3);			
		guDrawTriangleWithClip(&Flare3, &Flare4, &Flare1);



		grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE,
			GR_BLEND_ONE, GR_BLEND_ZERO);
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
				GR_COMBINE_FACTOR_ONE,
				GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		SelectTexture(g_TextureVolca99);
		grDrawTriangle(&Fond1, &Fond2, &Fond3);			
		grDrawTriangle(&Fond3, &Fond4, &Fond1);
		return;
	}

	if (g_demostate.TickInEffect<3333+3333)
	{
		grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA,
			GR_BLEND_ONE, GR_BLEND_ZERO);

		dwTmp = (g_demostate.TickInEffect-3333)/13;
		if (dwTmp>256)
			grConstantColorValue(0);
		else
			grConstantColorValue(dwTmp<<24);

		grDrawTriangle(&Fond1, &Fond3, &Fond2);
		grDrawTriangle(&Fond3, &Fond1, &Fond4);

		grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE,
			GR_BLEND_ONE, GR_BLEND_ZERO);

		iTmp = (g_demostate.TickInEffect-3333)/26;
		if (iTmp>128)
			iTmp = 128;

		Fond5.tmuvtx[0].sow = iTmp;
		Fond6.tmuvtx[0].sow = 256 - iTmp;
		Fond7.tmuvtx[0].sow = 256 - iTmp;
		Fond8.tmuvtx[0].sow = iTmp;

		Fond5.tmuvtx[0].tow = iTmp;
		Fond6.tmuvtx[0].tow = iTmp;
		Fond7.tmuvtx[0].tow = 256 - iTmp/2;
		Fond8.tmuvtx[0].tow = 256 - iTmp/2;

		grDrawTriangle(&Fond5, &Fond6, &Fond7);
		grDrawTriangle(&Fond7, &Fond8, &Fond5);
	}
}

void ByeBye_Casting0()
{
	FreeTexture(&g_TextureFlare);
	FreeTexture(&g_TextureVolca99);
	grDepthMask(FXTRUE);
}